
from gurobipy import *

# Create a model
m = Model("Apple_Farm_Optimization")

# Define decision variables
x1 = m.addVar(lb=25, ub=100, vtype=GRB.CONTINUOUS, name="Granny_Smith_Apples")
x2 = m.addVar(lb=50, ub=120, vtype=GRB.CONTINUOUS, name="McIntosh_Apples")

# Define the objective function
m.setObjective(2*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "Max_Granny_Smith")
m.addConstr(x2 <= 120, "Max_McIntosh")
m.addConstr(3*x1 + 3*x2 <= 15, "Cleaning_Machine_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Granny Smith Apples: {x1.x} kg")
    print(f"McIntosh Apples: {x2.x} kg")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
