
import gurobipy as gp

# Create a new model
m = gp.Model("Apple_Farm_Optimization")

# Decision variables
x = m.addVar(lb=25, ub=100, name="Granny_Smith_apples")  # kg
y = m.addVar(lb=50, ub=120, name="McIntosh_apples")    # kg

# Objective function: Maximize profit
m.setObjective(2*x + y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x <= 100, name="Granny_Smith_limit")
m.addConstr(y <= 120, name="McIntosh_limit")
m.addConstr(x >= 25, name="Granny_Smith_min")
m.addConstr(y >= 50, name="McIntosh_min")
m.addConstr(x + y <= 5, name="Cleaning_machine_limit")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Granny Smith apples: {x.varValue} kg")
    print(f"McIntosh apples: {y.varValue} kg")
    print(f"Max Profit: ${2*x.varValue + y.varValue}")
else:
    print("No optimal solution found.")
