
import gurobipy as gp

# Create a new model
m = gp.Model("Nut_Farm")

# Create variables
x = m.addVar(lb=0, name="almonds")  # Acres of almonds
y = m.addVar(lb=0, name="pecans")  # Acres of pecans

# Set objective function
m.setObjective(500*x + 600*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 80, "land")
m.addConstr(1.5*x + 3*y <= 275, "labor")
m.addConstr(200*x + 250*y <= 10000, "maintenance")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of almonds")
    print(f"Plant {y.x:.2f} acres of pecans")
    print(f"Maximum Revenue: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

