
from gurobipy import *

# Create a new model
m = Model("Nut_Farmer_Optimization")

# Define decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="almonds_acres")
y = m.addVar(vtype=GRB.CONTINUOUS, name="pecans_acres")

# Objective function: Maximize net revenue
m.setObjective(500*x + 600*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 80, "land_constraint")  # Land constraint
m.addConstr(1.5*x + 3*y <= 275, "labor_constraint")  # Labor constraint
m.addConstr(200*x + 250*y <= 10000, "maintenance_cost_constraint")  # Maintenance cost constraint

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Almonds acres: {x.x}")
    print(f"Pecans acres: {y.x}")
    print(f"Max net revenue: ${500*x.x + 600*y.x:.2f}")
else:
    print("No optimal solution found")
