
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
almonds = model.addVar(lb=0, name="almonds")
pecans = model.addVar(lb=0, name="pecans")

# Objective function: maximize net revenue
model.setObjective(500 * almonds + 600 * pecans, gurobi.GRB.MAXIMIZE)

# Land constraint: almonds + pecans <= 80
model.addConstr(almonds + pecans <= 80, name="land_constraint")

# Maintenance cost constraint: 200 * almonds + 250 * pecans <= 10000
model.addConstr(200 * almonds + 250 * pecans <= 10000, name="maintenance_cost_constraint")

# Labor constraint: 1.5 * almonds + 3 * pecans <= 275
model.addConstr(1.5 * almonds + 3 * pecans <= 275, name="labor_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Almonds: {almonds.varValue:.2f} acres")
    print(f"Pecans: {pecans.varValue:.2f} acres")
    print(f"Net revenue: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
