
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("milk_tea_toppings")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="red_bean")
y = model.addVar(vtype=GRB.INTEGER, name="pudding")

# Set objective function
model.setObjective(1.5 * x + 2 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(x <= 3, "red_bean_limit")
model.addConstr(1.5 * x + 3 * y >= 7, "sugar_requirement")
model.addConstr(2.5 * x + 1.2 * y >= 10, "butter_requirement")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal}")
    print(f"Red bean toppings: {x.x}")
    print(f"Pudding toppings: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

