
from gurobipy import *

# Create a model
m = Model("Milk_Tea_Optimization")

# Define variables
R = m.addVar(vtype=GRB.INTEGER, name="Red_Bean_Toppings", lb=0)
P = m.addVar(vtype=GRB.INTEGER, name="Pudding_Toppings", lb=0)

# Set objective function
m.setObjective(1.5*R + 2*P, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.5*R + 3*P >= 7, "Sugar_Constraint")
m.addConstr(2.5*R + 1.2*P >= 10, "Butter_Constraint")
m.addConstr(R <= 3, "Red_Bean_Limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red Bean Toppings: {R.x}")
    print(f"Pudding Toppings: {P.x}")
    print(f"Total Cost: ${1.5*R.x + 2*P.x:.2f}")
else:
    print("No optimal solution found.")
