
import gurobipy as gp

# Create a new model
model = gp.Model("MilkTea")

# Decision variables
R = model.addVar(lb=0, ub=3, name="Red_Bean_Toppings", vtype=gp.GRB.INTEGER)
P = model.addVar(lb=0, name="Pudding_Toppings", vtype=gp.GRB.INTEGER)

# Objective function: minimize cost
model.setObjective(1.5*R + 2*P, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(R <= 3, name="Red_Bean_Limit")
model.addConstr(1.5*R + 3*P >= 7, name="Sugar_Content")
model.addConstr(2.5*R + 1.2*P >= 10, name="Butter_Content")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Red Bean Toppings = {R.varValue}, Pudding Toppings = {P.varValue}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
