
import gurobipy as gp

# Create a new model
model = gp.Model("Toms_Shooter_Game")

# Create variables
s = model.addVar(vtype=gp.GRB.INTEGER, name="slow_shots")
q = model.addVar(vtype=gp.GRB.INTEGER, name="quick_shots")

# Set objective function
model.setObjective(3*s + 6*q, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(s + q <= 20, "total_shots")
model.addConstr(s >= 8, "min_slow_shots")
model.addConstr(q >= 5, "min_quick_shots")
model.addConstr(s <= 12, "max_slow_shots")
model.addConstr(q <= 12, "max_quick_shots")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Score: {model.objVal}")
    print(f"Slow Shots: {s.x}")
    print(f"Quick Shots: {q.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

