
from gurobipy import *

# Create a new model
m = Model("Tom_Shots")

# Define the variables
x = m.addVar(lb=8, ub=12, vtype=GRB.INTEGER, name="slow_shots")
y = m.addVar(lb=5, ub=12, vtype=GRB.INTEGER, name="quick_shots")

# Objective function: Maximize the total score
m.setObjective(3*x + 6*y, GRB.MAXIMIZE)

# Constraint: Total shots cannot exceed 20
m.addConstr(x + y <= 20, "total_shots_constraint")

# Optimize the model
m.optimize()

# Print out the results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of slow shots: {x.x}")
    print(f"Number of quick shots: {y.x}")
    print(f"Maximum score: {m.objVal}")
else:
    print("No optimal solution found")
