
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    S = model.addVar(lb=0, ub=12, name="Slow_Shots", vtype=gurobi.GRB.INTEGER)
    Q = model.addVar(lb=0, ub=12, name="Quick_Shots", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 3S + 6Q
    model.setObjective(3 * S + 6 * Q, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(S + Q <= 20, name="Total_Shots")
    model.addConstr(S >= 8, name="Min_Slow_Shots")
    model.addConstr(Q >= 5, name="Min_Quick_Shots")
    model.addConstr(S <= 12, name="Max_Slow_Shots")
    model.addConstr(Q <= 12, name="Max_Quick_Shots")

    # Update model
    model.update()

    # Solve the problem
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal slow shots: {S.varValue}")
        print(f"Optimal quick shots: {Q.varValue}")
        print(f"Max score: {3 * S.varValue + 6 * Q.varValue}")
    else:
        print("The problem is infeasible")

solve_problem()
