
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Appliance_Profit")

# Create decision variables
m = model.addVar(vtype=GRB.INTEGER, name="microwaves")
v = model.addVar(vtype=GRB.INTEGER, name="vents")

# Set objective function
model.setObjective(200*m + 300*v, GRB.MAXIMIZE)

# Add constraints
model.addConstr(300*m + 400*v <= 20000, "budget")
model.addConstr(m >= 30, "min_microwaves")
model.addConstr(m <= 65, "max_microwaves")
model.addConstr(v <= (1/3)*m, "vent_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Number of Microwaves: {m.x}")
    print(f"Number of Vents: {v.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

