
from gurobipy import *

# Create a model
m = Model("Appliance_Store_Profit")

# Define the decision variables
M = m.addVar(vtype=GRB.INTEGER, name="Microwaves")
V = m.addVar(vtype=GRB.INTEGER, name="Vents")

# Set the objective function to maximize profit (simplified as revenue)
m.setObjective(200*M + 300*V, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*M + 400*V <= 20000, "Budget_Constraint")
m.addConstr(M >= 30, "Min_Microwaves")
m.addConstr(M <= 65, "Max_Microwaves")
m.addConstr(V <= (1/3)*M, "Vent_to_Microwave_Ratio")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Microwaves to sell: {M.x}")
    print(f"Vents to sell: {V.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
