
import gurobipy as gp

# Create a new model
model = gp.Model("Microwave_Vent_Optimization")

# Decision Variables
M = model.addVar(lb=30, ub=65, name="Microwaves", vtype=gp.GRB.INTEGER)
V = model.addVar(lb=0, name="Vents", vtype=gp.GRB.INTEGER)

# Objective Function: Maximize profit
model.setObjective(200*M + 300*V, gp.GRB.MAXIMIZE)

# Budget Constraint
model.addConstr(300*M + 400*V <= 20000, name="Budget_Constraint")

# Vent Sales Constraint
model.addConstr(V <= M/3, name="Vent_Sales_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Microwaves = {M.varValue}, Vents = {V.varValue}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found.")
