
import gurobipy as gp

# Create a new model
model = gp.Model("Smoothie Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_smoothies")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_smoothies")

# Set the objective function
model.setObjective(2 * x + 3 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 5 * y <= 1000, "preparation_time")
model.addConstr(2 * x + y <= 750, "blending_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of blueberry smoothies: {x.x}")
    print(f"Number of chocolate smoothies: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

