
from gurobipy import *

# Create a model
m = Model("Smoothie_Optimization")

# Define decision variables
B = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Blueberry_Smoothies")
C = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Chocolate_Smoothies")

# Set the objective function
m.setObjective(2*B + 3*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*B + 5*C <= 1000, "Preparation_Time")
m.addConstr(2*B + C <= 750, "Blending_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blueberry Smoothies: {B.x}")
    print(f"Chocolate Smoothies: {C.x}")
    print(f"Maximum Profit: ${2*B.x + 3*C.x:.2f}")
else:
    print("No optimal solution found.")
