
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="blueberry_smoothies")
y = model.addVar(lb=0, name="chocolate_smoothies")

# Define the objective function
model.setObjective(2*x + 3*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3*x + 5*y <= 1000, name="preparation_time")
model.addConstr(2*x + y <= 750, name="blending_time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Blueberry smoothies: {x.varValue}")
    print(f"Chocolate smoothies: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
