
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("shampoo_conditioner")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="shampoo_bottles") # Integer number of shampoo bottles
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="conditioner_bottles") # Integer number of conditioner bottles


# Set objective
m.setObjective(5*x + 6*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 50, "shampoo_min")
m.addConstr(y >= 30, "conditioner_min")
m.addConstr(3*x + 4*y <= 300, "time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of shampoo bottles: {x.x}")
    print(f"Number of conditioner bottles: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

