
from gurobipy import *

# Create a model
m = Model("Shampoo_Conditioner_Problem")

# Define the variables
S = m.addVar(lb=50, vtype=GRB.INTEGER, name="Shampoo_Bottles")
C = m.addVar(lb=30, vtype=GRB.INTEGER, name="Conditioner_Bottles")

# Set the objective function to maximize profit
m.setObjective(5*S + 6*C, GRB.MAXIMIZE)

# Add the time constraint
m.addConstr(3*S + 4*C <= 300, "Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shampoo Bottles: {S.x}")
    print(f"Conditioner Bottles: {C.x}")
    print(f"Maximum Profit: ${5*S.x + 6*C.x}")
else:
    print("No optimal solution found")
