
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Chair_Profit_Maximization")

# Create decision variables
l = model.addVar(vtype=GRB.INTEGER, name="leather_chairs")  # Integer since we can't stock fractions of chairs
m = model.addVar(vtype=GRB.INTEGER, name="mesh_chairs")

# Set objective function
model.setObjective(250 * l + 200 * m, GRB.MAXIMIZE)

# Add constraints
model.addConstr(500 * l + 300 * m <= 50000, "budget_constraint")
model.addConstr(l + m <= 125, "demand_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of leather chairs: {l.x}")
    print(f"Number of mesh chairs: {m.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

