
from gurobipy import *

# Create a new model
m = Model("Chair_Sales")

# Define the decision variables
L = m.addVar(vtype=GRB.INTEGER, name="Leather_Chairs")
M = m.addVar(vtype=GRB.INTEGER, name="Mesh_Chairs")

# Set the objective function to maximize profit
m.setObjective(250*L + 200*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*L + 300*M <= 50000, "Budget_Constraint")
m.addConstr(L + M <= 125, "Demand_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Leather Chairs: {L.x}")
    print(f"Number of Mesh Chairs: {M.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")

