
import gurobi

def solve_chair_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    L = model.addVar(name="Leather_Chairs", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
    M = model.addVar(name="Mesh_Chairs", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(250*L + 200*M, gurobi.GRB.MAXIMIZE)

    # Cost constraint
    model.addConstr(500*L + 300*M <= 50000, name="Cost_Constraint")

    # Demand constraint
    model.addConstr(L + M <= 125, name="Demand_Constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Leather Chairs = {L.varValue}, Mesh Chairs = {M.varValue}")
        print(f"Maximum Profit: ${model.objVal}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_chair_problem()
