
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("salad_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="caesar_salads") # Integer number of caesar salads
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="house_salads") # Integer number of house salads


# Set objective function
model.setObjective(5*x + 8*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 30*y <= 2000, "lettuce_constraint")
model.addConstr(y >= 3*x, "demand_constraint")
model.addConstr(x >= 8, "min_caesar_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Caesar Salads: {x.x}")
    print(f"Number of House Salads: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

