
from gurobipy import *

# Create a model
m = Model("Salad_Optimization")

# Define decision variables
C = m.addVar(name='Caesar_Salads', vtype=GRB.INTEGER, lb=0)
H = m.addVar(name='House_Salads', vtype=GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(5*C + 8*H, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*C + 30*H <= 2000, name='Lettuce_Limitation')
m.addConstr(H >= 3*C, name='Popularity_Constraint')
m.addConstr(C >= 8, name='Minimum_Caesar_Salads')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: {C.varName} = {int(C.x)}")
    print(f"Optimal Solution: {H.varName} = {int(H.x)}")
else:
    print("Model is infeasible")

