
import gurobi

def solve_salad_problem():
    # Create a new model
    model = gurobi.Model()

    # Variables
    x = model.addVar(name="Caesar_Salads", lb=8, vtype=gurobi.GRB.INTEGER)  # At least 8 Caesar salads
    y = model.addVar(name="House_Salads", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(5 * x + 8 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x + 30 * y <= 2000, name="Lettuce_Constraint")
    model.addConstr(y >= 3 * x, name="House_vs_Caesar_Constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Caesar Salads = {x.varValue}, House Salads = {y.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_salad_problem()
