
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagels") # batches of bagels
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="croissants") # batches of croissants

# Set objective function
model.setObjective(7.5*x + 5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + 1.5*y <= 2500, "mixer_constraint")
model.addConstr(3.5*x + 2*y <= 2500, "oven_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal:.2f}")
    print(f"Bagels: {x.x:.2f} batches")
    print(f"Croissants: {y.x:.2f} batches")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

