
from gurobipy import *

# Create a new model
m = Model("Joy_Bakery")

# Define the decision variables
B = m.addVar(name="Bagels", vtype=GRB.CONTINUOUS, lb=0)
C = m.addVar(name="Croissants", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: Maximize profit
m.setObjective(7.5*B + 5*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*B + 1.5*C <= 2500, name="Dough_Mixer_Constraint")
m.addConstr(3.5*B + 2*C <= 2500, name="Oven_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagels: {B.x}")
    print(f"Croissants: {C.x}")
    print(f"Total Profit: ${7.5*B.x + 5*C.x:.2f}")
else:
    print("No optimal solution found.")
