
import gurobi as gp

# Create a new model
model = gp.Model("Joy_Bakery_Optimization")

# Define the decision variables
x = model.addVar(name="bagels", lb=0, vtype=gp.GRB.CONTINUOUS)  # Batches of bagels
y = model.addVar(name="croissants", lb=0, vtype=gp.GRB.CONTINUOUS)  # Batches of croissants

# Objective function: Maximize profit
model.setObjective(7.5 * x + 5 * y, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2 * x + 1.5 * y <= 2500, name="dough_mixer_constraint")  # Dough mixer constraint
model.addConstr(3.5 * x + 2 * y <= 2500, name="oven_constraint")  # Oven constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of bagels: {x.varValue}")
    print(f"Optimal batches of croissants: {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible or has an error.")
