
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_store")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases") # Allowing fractional bookcases/tables for simplicity.  Could be changed to GRB.INTEGER
y = m.addVar(vtype=GRB.CONTINUOUS, name="tables")

# Set objective
m.setObjective(150*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 8*y <= 1200, "floor_space")
m.addConstr(0.8*x - 0.2*y >= 0, "min_bookcases")
m.addConstr(1200*x + 1500*y <= 50000, "capital")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of bookcases: {x.x:.2f}")
    print(f"Number of tables: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

