
from gurobipy import *

# Create a model
m = Model("Furniture_Store")

# Define the decision variables
x_b = m.addVar(lb=0, vtype=GRB.INTEGER, name="bookcases")
x_d = m.addVar(lb=0, vtype=GRB.INTEGER, name="dining_tables")

# Set the objective function
m.setObjective(150*x_b + 200*x_d, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x_b + 8*x_d <= 1200, "floor_space")
m.addConstr(x_b >= 0.20*(x_b + x_d), "bookcase_percentage")
m.addConstr(1200*x_b + 1500*x_d <= 50000, "capital")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Bookcases:", x_b.x)
    print("Dining Tables:", x_d.x)
    print("Maximum Profit:", m.objVal)
else:
    print("No optimal solution found.")
