
import gurobi

def solve_furniture_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, name="Bookcases", vtype=gurobi.GRB.INTEGER)
    D = model.addVar(lb=0, name="Dining_Tables", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(150 * B + 200 * D, gurobi.GRB.MAXIMIZE)

    # Floor space constraint
    model.addConstr(15 * B + 8 * D <= 1200, name="Floor_Space")

    # Bookcase percentage constraint
    model.addConstr(4 * B >= D, name="Bookcase_Percentage")

    # Capital constraint
    model.addConstr(1200 * B + 1500 * D <= 50000, name="Capital")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Bookcases: {B.varValue}")
        print(f"Dining Tables: {D.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_furniture_store_problem()
