
import gurobipy as gp

# Create a new model
model = gp.Model("TicketOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="premium_tickets")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_tickets")

# Set objective function
model.setObjective(50*x + 30*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y == 500, "total_tickets")
model.addConstr(x >= 100, "min_premium")
model.addConstr(y >= 3*x, "regular_preference")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Premium Tickets (x): {x.x}")
    print(f"Regular Tickets (y): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No solution found.")

