
from gurobipy import *

# Create a model
m = Model("Ticket_Sales")

# Define variables
P = m.addVar(name='premium_tickets', vtype=GRB.INTEGER, lb=0)
R = m.addVar(name='regular_tickets', vtype=GRB.INTEGER, lb=0)

# Add constraints
m.addConstr(P + R == 500, name='total_tickets')
m.addConstr(P >= 100, name='min_premium_tickets')
m.addConstr(R >= 3*P, name='preference_regular')

# Set the objective function
m.setObjective(50*P + 30*R, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Premium tickets: {P.x}')
    print(f'Regular tickets: {R.x}')
    print(f'Maximum profit: ${50*P.x + 30*R.x:.2f}')
else:
    print('No optimal solution found')
