
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("flight_profit")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="first_class")
y = m.addVar(vtype=GRB.INTEGER, name="economy_class")

# Set objective
m.setObjective(150*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, "total_tickets")
m.addConstr(x >= 20, "min_first_class")
m.addConstr(y >= 3*x, "economy_ratio")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"First-Class Tickets: {x.x}")
    print(f"Economy-Class Tickets: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

