
from gurobipy import *

# Create a new model
m = Model("Flight_Ticket_Optimization")

# Define the decision variables
x = m.addVar(name="first_class_tickets", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="economy_class_tickets", vtype=GRB.INTEGER, lb=0)

# Set the objective function: Maximize profit
m.setObjective(150*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, name="total_tickets_constraint")
m.addConstr(x >= 20, name="minimum_first_class_constraint")
m.addConstr(y >= 3*x, name="economy_class_preference_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First-class tickets: {x.x}")
    print(f"Economy-class tickets: {y.x}")
    print(f"Total profit: ${150*x.x + 350*y.x}")
else:
    print("No optimal solution found")
