
import gurobi

def solve_flight_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=0, name="first_class_tickets")
    y = model.addVar(lb=0, name="economy_class_tickets")

    # Objective function: Maximize profit
    model.setObjective(150*x + 350*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 150, name="total_tickets")
    model.addConstr(x >= 20, name="min_first_class")
    model.addConstr(y >= 3*x, name="economy_class_preference")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of first-class tickets to sell: {x.varValue}")
        print(f"Number of economy-class tickets to sell: {y.varValue}")
        print(f"Maximum profit: ${150*x.varValue + 350*y.varValue}")
    else:
        print("No optimal solution found.")

solve_flight_ticket_problem()
