
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("crop_optimization")

# Create decision variables
x = m.addVar(lb=0, name="peas")  # Acres of peas
y = m.addVar(lb=0, name="beans") # Acres of beans

# Set objective function
m.setObjective(100*x + 160*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 30, "land")
m.addConstr(30*x + 50*y <= 1300, "bug_spray")
m.addConstr(2*x + 1.5*y <= 50, "care_taking")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of peas")
    print(f"Plant {y.x:.2f} acres of beans")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

