
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define the decision variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="Peas_Acres", lb=0)
B = m.addVar(vtype=GRB.CONTINUOUS, name="Beans_Acres", lb=0)

# Set the objective function: Maximize profit
m.setObjective(100*P + 160*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*P + 50*B <= 1300, "Bug_Spray_Budget")
m.addConstr(2*P + 1.5*B <= 50, "Care_Taking_Time")
m.addConstr(P + B <= 30, "Total_Acres")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of Peas: {P.x}")
    print(f"Acres of Beans: {B.x}")
    print(f"Total Profit: ${100*P.x + 160*B.x:.2f}")
else:
    print("No optimal solution found")
