
import gurobi

def solve_gardener_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    P = model.addVar(lb=0, name="P")  # acres of peas
    B = model.addVar(lb=0, name="B")  # acres of beans

    # Objective function: Maximize profit
    model.setObjective(100 * P + 160 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(P + B <= 30, name="total_acres")
    model.addConstr(30 * P + 50 * B <= 1300, name="bug_spray_budget")
    model.addConstr(2 * P + 1.5 * B <= 50, name="care_taking_hours")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of peas: {P.varValue}")
        print(f"Optimal acres of beans: {B.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_gardener_problem()
