
import gurobipy as gp

# Create a new model
model = gp.Model("Bookstore Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hardcover")  # Integer number of hardcover books
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paperback") # Integer number of paperback books

# Set objective function
model.setObjective(5*x + 2*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 500, "total_books")
model.addConstr(x >= 50, "min_hardcover")
model.addConstr(y >= 5*x, "paperback_preference")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of hardcover books: {x.x}")
    print(f"Number of paperback books: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

