
from gurobipy import *

# Create a model
m = Model("Bookstore_Profit")

# Define variables
H = m.addVar(lb=50, vtype=GRB.INTEGER, name="Hardcover_Books")
P = m.addVar(vtype=GRB.INTEGER, name="Paperback_Books")

# Add constraints
m.addConstr(H + P <= 500, "Total_Books_Constraint")
m.addConstr(P >= 5 * H, "Preference_Constraint")

# Objective function: Maximize profit
m.setObjective(5*H + 2*P, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hardcover Books: {H.x}")
    print(f"Paperback Books: {P.x}")
    print(f"Maximum Profit: ${5*H.x + 2*P.x:.2f}")
else:
    print("No optimal solution found")
