
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jelly_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="blue_jellies")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="red_jellies")

# Set objective function
m.setObjective(5*x + 7*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 3*y >= 30, "calcium_req")
m.addConstr(x + 2*y >= 25, "potassium_req")
m.addConstr(3*x + y >= 30, "sodium_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of blue jelly pouches: {x.x}")
    print(f"Number of red jelly pouches: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

