
from gurobipy import *

# Create a model
m = Model("Jelly_Pouch_Optimization")

# Define decision variables
x_b = m.addVar(vtype=GRB.CONTINUOUS, name="blue_pouches")
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="red_pouches")

# Set the objective function
m.setObjective(5*x_b + 7*x_r, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_b + 3*x_r >= 30, "calcium_requirement")
m.addConstr(x_b + 2*x_r >= 25, "potassium_requirement")
m.addConstr(3*x_b + x_r >= 30, "sodium_requirement")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue pouches: {x_b.x}")
    print(f"Red pouches: {x_r.x}")
    print(f"Total cost: ${5*x_b.x + 7*x_r.x:.2f}")
else:
    print("No optimal solution found")
