
import gurobipy as gp

# Create a new model
model = gp.Model("JellyPouches")

# Define the variables
B = model.addVar(name="Blue", lb=0, vtype=gp.GRB.INTEGER)  # Number of blue jelly pouches
R = model.addVar(name="Red", lb=0, vtype=gp.GRB.INTEGER)   # Number of red jelly pouches

# Define the objective function
model.setObjective(5*B + 7*R, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2*B + 3*R >= 30, name="Calcium")      # Calcium requirement
model.addConstr(B + 2*R >= 25, name="Potassium")     # Potassium requirement
model.addConstr(3*B + R >= 30, name="Sodium")        # Sodium requirement

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: B = {B.varValue}, R = {R.varValue}")
    print(f"Minimum cost: ${5*B.varValue + 7*R.varValue}")
else:
    print("The model is infeasible.")
