
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("gabriels_diet")

# Create variables
x = m.addVar(lb=0, name="lemons") # pounds of lemons
y = m.addVar(lb=0, name="pecans") # pounds of pecans


# Set objective function
m.setObjective(12*x + 10*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x + 5*y >= 25, "calcium")
m.addConstr(4*x + 4*y >= 18, "potassium")
m.addConstr(7*x + 9*y >= 19, "zinc")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Pounds of Lemons: {x.x:.2f}")
    print(f"Pounds of Pecans: {y.x:.2f}")

