
from gurobipy import *

# Create a new model
m = Model("Gabriel_Nutrition")

# Add variables
lemons = m.addVar(name="lemons", lb=0)
pecans = m.addVar(name="pecans", lb=0)

# Set the objective function to minimize cost
m.setObjective(12*lemons + 10*pecans, GRB.MINIMIZE)

# Add constraints for nutritional requirements
m.addConstr(3*lemons + 5*pecans >= 25, name="calcium")
m.addConstr(4*lemons + 4*pecans >= 18, name="potassium")
m.addConstr(7*lemons + 9*pecans >= 19, name="zinc")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Gabriel should eat {lemons.x} pounds of lemons and {pecans.x} pounds of pecans.")
else:
    print("No optimal solution found. The problem might be infeasible.")

m.write("gabriel_nutrition.lp")
