
import gurobi

def solve_nutrition_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    L = model.addVar(lb=0, name="Lemons")  # Pounds of lemons
    P = model.addVar(lb=0, name="Pecans")  # Pounds of pecans

    # Objective function: Minimize the total cost
    model.setObjective(12*L + 10*P, gurobi.GRB.MINIMIZE)

    # Add constraints for nutritional requirements
    model.addConstr(3*L + 5*P >= 25, name="CalciumRequirement")
    model.addConstr(4*L + 4*P >= 18, name="PotassiumRequirement")
    model.addConstr(7*L + 9*P >= 19, name="ZincRequirement")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objVal:.2f}")
        print(f"Pounds of lemons: {L.x:.2f}")
        print(f"Pounds of pecans: {P.x:.2f}")
    else:
        print("The problem is infeasible.")

solve_nutrition_problem()
