
import gurobipy as gp

# Create a new model
model = gp.Model("HockeyArenaOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="heated_seats") # Integer number of heated seats
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_seats") # Integer number of regular seats

# Set the objective function
model.setObjective(30*x + 20*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 300, "capacity")
model.addConstr(x >= 50, "min_heated")
model.addConstr(y >= 3*x, "regular_preference")


# Optimize the model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print the optimal solution
    print(f"Optimal Solution:")
    print(f"Number of heated seats (x): {x.x}")
    print(f"Number of regular seats (y): {y.x}")
    print(f"Maximum profit: ${model.objVal}")

