
from gurobipy import *

# Create a new model
m = Model("Hockey_Arena_Profit")

# Define variables
H = m.addVar(vtype=GRB.CONTINUOUS, name="Heated_Seats", lb=0)
R = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Seats", lb=0)

# Objective function: Maximize profit
m.setObjective(30*H + 20*R, GRB.MAXIMIZE)

# Constraints
m.addConstr(H + R <= 300, "Capacity")
m.addConstr(H >= 50, "Min_Heated_Seats")
m.addConstr(R >= 3*H, "Preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated Seats: {H.x}")
    print(f"Regular Seats: {R.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
