
import gurobipy as gp

# Create a new model
m = gp.Model("Hockey_Arena_Seating")

# Decision Variables
H = m.addVar(name="Heated_Seats", lb=50)  # At least 50 heated seats
R = m.addVar(name="Regular_Seats")  # No lower bound specified, but will be constrained

# Objective Function: Maximize profit
m.setObjective(30*H + 20*R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(H + R <= 300, name="Arena_Capacity")  # Total seats do not exceed 300
m.addConstr(R >= 3*H, name="Preference_Regular")  # Regular seats are at least 3 times heated seats

# Solve the model
m.solve()

# Output
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Heated Seats = {H.varValue}, Regular Seats = {R.varValue}")
    print(f"Maximum Profit: ${30*H.varValue + 20*R.varValue}")
else:
    print("No optimal solution found.")
